import java.net.*;
import java.io.*;

public class EchoServerCommThread extends Thread
{
  protected Socket socket;
  protected EchoServerConsole escon;
  public EchoServerCommThread(EchoServerConsole escon, 
                              Socket socket)
  {
    this.socket = socket;
    this.escon = escon;
  }
  public void run()
  {
    //Deklaracje zmiennych
    BufferedReader brinp = null;
    DataOutputStream out = null;
    String threadName = getName();
    
    //inicjalizacja strumieni
    try{
      brinp = new BufferedReader(
        new InputStreamReader(
          socket.getInputStream()
        )
      );
      out = new DataOutputStream(socket.getOutputStream());
    }
    catch(IOException e){
      escon.log(threadName + "| Bd przy tworzeniu strumieni " + e);
      escon.removeThread(this);
      return;
    }
    String line = null;
    
    //ptla gwna
    while(true){
      try{
        line = brinp.readLine();
        escon.log(threadName + "| Odczytano lini: " + line);
        
        //badanie warunku zakoczenia pracy
        if((line == null) || "quit".equals(line)){
          escon.log(threadName + "| Zakoczenie pracy z klientem: " + socket);
          socket.close();
          escon.removeThread(this);
          return;
        }
        else{ //odesanie danych do klienta
          out.writeBytes(line + "\n\r");
          escon.log(threadName + "| Wysano lini: " + line);
        }
      }
      catch(IOException e){
        escon.log(threadName + "| Bd wejcia-wyjcia." + e);
        escon.removeThread(this);
        return;
      }
    }
  }
  public void interrupt()
  {
    super.interrupt();
    try{
      socket.close();
    }
    catch(IOException e){}
  }
  public String getInfo()
  {
    String info = this.getName() + "| ";
    info += "IP " + socket.getInetAddress().getHostAddress() + " ";
    info += "Port " + socket.getPort() + " ";
    return info;
  }
}
